%define module_version 9
%define module_name Image-Base-Prima
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Image/Base.pm) perl(Package/Stash.pm) perl(Path/Class.pm) perl(Pod/Simple/HTML.pm) perl(Prima.pm) perl(Prima/Const.pm) perl(Prima/noX11.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 9
Release: alt1
Summary: Image::Base drawing into Prima windows and images.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/image-base-prima/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Image::Base::Prima::Drawable' extends `Image::Base' to draw into a
`Prima::Drawable' drawable, meaning a widget window, off-screen image,
printer, postscript accumulator, etc.

The native Prima drawing has many more features, but this module can point
some `Image::Base' style code at a Prima image etc.

X,Y coordinates are the usual `Image::Base' style 0,0 at the top-left
corner.  Prima works from 0,0 as the bottom-left but
`Image::Base::Prima::Drawable' converts.  No attention is paid to the Prima
`translate()' origin change, which ends up meaning the top-left shifts up
etc with the translate.  That seems reasonably logical, is it the best way
though?

None of the drawing functions here do a `$drawable->begin_paint()' or a
`$drawable->begin_doc()' (for `Prima::PS::Drawable').  That's left to
the application.  A `begin_paint()' of course happens automatically in an
`onPaint' handler call.  The symptom of forgetting a `begin_paint()' is
generally that lines, rectangles and ellipses don't draw anything, though
`xy()' might come out because it uses `$drawable->pixel' (but don't
rely on that).  Forgetting a `begin_doc()' for PS output may cause various
warnings about `undef'.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes
%perl_vendor_privlib/I*

%changelog
