# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Data/Dumper.pm) perl(FindBin.pm) perl(HTML/Entities.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(XML/LibXML.pm) perl(XML/Parser/Expat.pm) perl(XML/SAX.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Image-Base-SVG
%define upstream_version 5

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    SVG image file output
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Image/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Image/Base.pm)
BuildRequires: perl(SVG.pm)
BuildRequires: perl(SVG/Parser.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
'Image::Base::SVG' extends 'Image::Base' to create or update SVG format
image files using the 'SVG.pm' module (see the SVG::Manual manpage).

'Image::Base' is pixel oriented so isn't really the sort of thing SVG is
meant for, but this module can direct some 'Image::Base' style code at an
'SVG' object. Of course the 'SVG' module has many more features if used
natively.

It's often fairly easy to spit out SVG directly too, and for instance the
'Image::Base::SVGout' module can do that. The advantage of the 'SVG'
document object model comes when combining images or fragments, or going
through elements for post-facto mangling.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYING Changes META.json META.yml  SIGNATURE
%perl_vendor_privlib/*

%changelog
