# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Flow.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Image-Bitmap2Paths
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension to convert line-drawing (and font's) bitmaps to paths (of vector formats).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IL/ILYAZ/modules/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
v0.01 is a very early stage of refactoring a generally useful code
out of the script hex_parse.pl used to generate vector fonts on

  http://ilyaz.org/fonts

Hairlines are converted to the corresponding paths (which are assumed to be
visualized by drawing with an appropriate pen).  The rest is converted to .e'blobs.e'
with appropriately calculated boundary paths.

Due to the workflow of postprocessing (drawing of hairlines is done by `ExpandStroke()'
in `fontforge', and its programming interface is not flexible enough to treat different
paths differently), the output boundaries of blobs .e'go through middles of boundary
pixels.e'.e'.ei.e'in the same way as for hairlines.

One should keep in mind that currently the overwhelming amount of work focuses on the
detection of .e'junctions.e'.e'.ei.e'the places where hairlines meet and/or cross each other.
Unfortunately, this meant that so far, almost no resources were left to cover .e'the sexier.e'
problem of finding .e'a beautiful curve.e' approximating the given rough broken line path.
(On the first stage of their processing, the extracted paths connect centers of pixels.
So far, the only .e'really nice beautification engine.e' is one to extract the longish
straight segments out of such .e'pixellated paths.e'.  The rest of the paths is converted
 to curves in an extremely naive way now.)

(Contrary to my initial expectations, decyphering the geometry of a junction from its
.e'pixellated version.e' turned out to be an unimaginably harder process that what one could
predict.  Fortunately.e'.ei.e'while the code is convoluted, bulky and ugly.e'.ei.e'the majority of
the complications has been worked out, and this process is now .e'almost.e' flawless.e'.ei.e'as
far as the testbed of `unifont'.e's glyphs shows.  On the other hand, the details of how
hairlines .e'enter.e' into blobs are not fully worked out yet.)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO Changes README
%perl_vendor_privlib/I*
%perl_vendor_privlib/auto/*

%changelog
