# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Imager.pm) perl(Imager/Fill.pm) perl(List/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Image-DominantColors
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Find dominant colors in an image with k-means clustering.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GI/GIDEON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module does just one simple thing. It scans an image and clusters colors with the k-means clustering 
algorithm to give you the most dominant colors in that image.

Here is a live demo : http://www.tryperl.com/dominantcolors/

This is how it works, I would advise leaving the clusters to a default 3 which works best with images.:

    use Image::DominantColors;
    use Data::Dumper;
    
    
    my $dmt = Image::DominantColors->new({file => 'some_path/img.jpg', clusters => 4});
    #OR three clusters is default
    my $dmt = Image::DominantColors->new({file => 'some_path/img.jpg'});
    my $r = $dmt->getDominantColors();
    
    print Dumper($r);
	#This outputs the following:
    # [
    #           {
    #             'r' => 31,
    #             'b' => 23,
    #             'g' => 15
    #           },
    #           {
    #             'r' => 193,
    #             'b' => 41,
    #             'g' => 84
    #           },
    #           {
    #             'r' => 114,
    #             'b' => 136,
    #             'g' => 128
    #           },
    #           {
    #             'r' => 61,
    #             'b' => 82,
    #             'g' => 66
    #           }
    # ];
    ...


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/I*

%changelog
