# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Image-Imlib2
%define upstream_version 2.03

%{?perl_default_filter}

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt7_26

Summary:	Interface to the Imlib2 image library
License:	GPL+ or Artistic
Group:		Development/Perl
URL:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/Image/%{upstream_name}-%{upstream_version}.tar.gz
Patch0:		Image-Imlib2-2.03-replace-imlib2-config-with-pkg-config.patch

BuildRequires:  pkgconfig(imlib2)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(ExtUtils/XSBuilder.pm)
BuildRequires:  perl-devel
Source44: import.info


%description
Image::Imlib2 is a Perl port of Imlib2, a graphics library that does image file
loading and saving as well as manipulation, arbitrary polygon support, etc. It
does ALL of these operations FAST. It allows you to create colour images using
a large number of graphics primitives, and output the images in a range of
formats.

Image::Imlib2::Polygon and Image::Imlib2::ColorRange are described following
Image::Imlib2 but may be referenced before their description.

Note that this is an early version of my attempt at a Perl interface to Imlib2.
Currently, the API is just to test things out. Not everything is supported, but
a great deal of functionality already exists. If you think the API can be
tweaked to be a bit more intuitive, drop me a line!

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch0  -p0

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
rm -r t/simple.t
./Build test

%install
./Build install destdir=%{buildroot}

# Fix permissions
%_fixperms %{buildroot}%{perl_vendor_archlib}

%files
%doc CHANGES README META.yml
%{perl_vendor_archlib}/auto/Image
%{perl_vendor_archlib}/Image


%changelog
