# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Section/Simple.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Glob.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(Log/Handler.pm) perl(Moo.pm) perl(Pod/Usage.pm) perl(Set/Array.pm) perl(Set/FA/Element.pm) perl(Test/Pod.pm) perl(Test/Simple.pm) perl(Types/Standard.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Image-Magick-CommandParser
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Parse any command line acceptable to convert or mogrify
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
`Image::Magick::CommandParser' is a stand-alone parser for command lines acceptable to the
Imagemagick programs `convert' and `mogrify'.

It aims to handle all constructs supported by Imagemagick itself, but it's vital to understand
that this module does not use any component of Imagemagick. Hence the *stand-alone* just above.

In particular the output is a stack, accessible via the `$object -> stack' method, which
returns an array of hashrefs.

The stack is managed by an object of type the Set::Array manpage. See the the FAQ entry elsewhere in this document for details.

The result - as a space-separated string of tokens detected in the command - is returned by
the result() entry elsewhere in this document.

The actual parsing is done with the Set::FA::Element manpage.

Consult the the FAQ entry elsewhere in this document and t/test.t for specific examples of command line options supported. A few of
them are included here:

=over 4

=item o All command options of the form [-+][a-zA-Z]+

=item o Redirecting input from files

=over 4

=item o convert magick:rose -label @t/label.1.txt -format "%%l label" rose.png

=back

=item o File globbing

=over 4

=item o convert colors/*s*.png -append output.png

=back

=item o Explicit image format

=over 4

=item o convert rgb:camera.image -size 320x85 output.png

=back

=item o Built-in images and patterns

=over 4

=item o convert pattern:bricks -size 320x85 output.png

=back

=item o Standard input and output

=over 4

=item o convert gif:- -size 320x85 output.png

=item o convert magick:logo -size 320x85 gif:-

=back

=item o File handle numbers

=over 4

=item o convert fd:3 png:fd:4 gif:fd:5 fd:6 -append output.png

=back

=item o The apparently endless variations of the geometry parameter

Samples:

=over 4

=item o 320x85

=item o 50%%

=item o 60%%x40

=item o 320x85+0+0

=item o 60x40%%+0+0

=item o 50%%!+0+0

=back

=item o Built-in special files

Samples:

=over 4

=item o logo:

=item o magick:rose

=back

=item o Output label format strings

=over 4

=item ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changelog.ini Changes
%perl_vendor_privlib/I*

%changelog
