%define module_name Image-Magick-Safer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/LibMagic.pm) perl(Image/Magick.pm) perl(Test/Kwalitee.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Wrap Image::Magick Read method to check magic bytes
Group: Development/Perl
License: perl
URL: https://metacpan.org/module/Image::Magick::Safer

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEEJO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Image::Magick::Safer is a drop in wrapper around Image::Magick, it adds a
magic byte check to the `Read' method to check the file MIME type using
the File::LibMagic manpage. If a file looks questionable then it will prevent the file
being passed to the real Image::Magick::Read method and return an error.
If a file cannot be opened, because it does not exist or it is prefixed
with a pipe, an error will also be returned.

You can replace any calls to `Image::Magick' with `Image::Magick::Safer'
and the functionality will be retained with the added Read protection. The
aliases for `Read' will also be made safe.

If you need to override the default MIME types then you can set the modules
`$Image::Magick::Safer::Unsafe' hash to something else or add extra types:

_# add SVG check to the defaults
_$Image::Magick::Safer::Unsafe->{'image/svg+xml'} = 1;

The default MIME types considered unsafe are as follows:

_text/plain
_application/x-compress
_application/x-compressed
_application/gzip
_application/bzip2
_application/x-bzip2
_application/x-gzip
_application/x-rar
_application/x-z
_application/z

Leading pipes are also considered unsafe, as well as any reference to files
that cannot be found.

Note that i make NO GUARANTEE that this will fix and/or protect you from
exploits, it's just another safety check. You should update to the latest
version of ImageMagick to protect yourself against potential exploits.

Also note that to install the the File::LibMagic manpage module you will need to have
both the library (libmagic.so) and the header file (magic.h). See the perldoc
for the File::LibMagic manpage for more information.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/I*

%changelog
