# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Remove.pm) perl(File/Slurp.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(IO/File.pm) perl(Imager.pm) perl(Imager/Screenshot.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Object/Tiny/XS.pm) perl(Params/Util.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/File/Cleaner.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(inc/Module/Install/DSL.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name Imager-Search
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Find images within other images
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The regular expression engine provided with Perl has demonstrated itself
to be both fully featured and extremely fast for tasks involving searching
for patterns within a string.

The CPAN module the Imager manpage has demonstrated robust functionality and
excellent speed across all common operating system platforms for tasks
involving working with images.

The goal of Imager::Search takes the best features from the Imager manpage and the
regular expression engine and combines them to produce a simple pure perl
image recognition engine for systems in which the images are pixel perfect.

And equally importantly, Imager::Search does it very very fast.

Benchmarking a simple program that continuously monitors a 1024x768 display
for a single target image on a cheap 1.5Ghtz Windows machine demonstrated
a monitoring rate of 5 frames per second using the default BMP24 driver.

That is, 0.2 seconds to capture the screenshot, convert it into a searchable
string, generate a search regexp, execute the regexp and then convert the
results into match objects.

Finally, Imager::Search itself is pure Perl, and should work quite
simply on any platform that the the Imager manpage module supports, which at time
of writing includes Windows, Mac OS X and most other forms of Unix.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/I*

%changelog
