# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Fast.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(IPC/Run.pm) perl(JSON/MaybeXS.pm) perl(LWP/UserAgent.pm) perl(Object/Result.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_name InfluxDB-HTTP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: The Perl way to interact with InfluxDB!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RA/RAPHI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
InfluxDB::HTTP allows you to interact with the InfluxDB HTTP API. The module essentially provides
one method per InfluxDB HTTP API endpoint, that is `ping', `write' and `query'.

    use InfluxDB::HTTP;

    my $influx = InfluxDB::HTTP->new();

    my $ping_result = $influx->ping();
    print "$ping_result\n";

    my $query = $influx->query(
        [ 'SELECT Lookups FROM _internal.monitor.runtime WHERE time > '.(time - 60)*1000000000, 'SHOW DATABASES'],
        epoch => 's',
    );

    print "$query\n";

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes
%perl_vendor_privlib/I*

%changelog
