%define module_name Iterator-Simple-Lookahead
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(Iterator/Simple.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Simple iterator with lookahead and unget
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PS/PSCUST/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module encapsulates an iterator function. An iterator function returns the
next element in the stream on each call, and returns `undef' on end of input.

The iterator can return a code reference - this new iterator is inserted at the 
head of the queue.

The object allows the user to `peek()' the Nth element of the stream without
consuming it, or to get it and remove from the stream.

A list of items can also be pushed back to the stream by `unget()', 
to be retrieved in the subsequent `next()' calls. The next item can also be
retrieved by calling `$iter->()'.

The input list to the constructor and to `unget()' contains items to be
retrieved on each `next()' call, or code references to be called to extract the
next item from the stream.

Other types of input can be converted to a code reference by `iter()' of 
Iterator::Simple.

This module is built on top of Iterator::Simple 
and returns iterators that are compatible with the former, 
i.e. an object of type `Iterator::Simple::Lookahead' 
can be used as an input to `iter()'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
