%filter_from_requires /perl.JE.parsetoperl.pl./d
%add_findreq_skiplist %perl_vendor_privlib/JE/*pl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Date/Parse.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Tie/RefHash/Weak.pm) perl(Time/Local.pm) perl(Time/Zone.pm) perl(constant.pm) perl(re.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _without_test 1
%define module_version 0.066
%define module_name JE
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.066
Release: alt1
Summary: Pure-Perl ECMAScript (JavaScript) Engine
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SP/SPROUT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
JE, short for JavaScript::Engine (imaginative, isn't it?), is a pure-Perl 
JavaScript engine. Here are some of its
strengths:

=over 4

=item -

Easy to install (no C compiler necessary*)

=item -

The parser can be extended/customised to support extra (or
fewer) language features (not yet complete)

=item -

All JavaScript datatypes can be manipulated directly from Perl (they all
have overloaded operators)

=item -

The JavaScript datatypes provide `TO_JSON' methods for compatibility with
JSON.pm.

=back

JE's greatest weakness is that it's slow (well, what did you expect?).  It
also uses and leaks lots of memory.  (There is an experimental
JE::Destroyer (q.v.) module that solves this if you load
it first and then call `JE::Destroyer::destroy($j)' on the JE object when
you have finished with it.)

* If you are using perl 5.9.3 or lower, then the Tie::RefHash::Weak manpage is
required. Recent versions of it require the Variable::Magic manpage, an XS module
(which requires a compiler of course), but version 0.02 of the former is
just pure Perl with no XS dependencies.

There is currently an experimental version of the run-time engine, which is
supposed to be faster, although it currently makes compilation slower. (If
you serialise the compiled code and use that, you should notice a
speed-up.) It will eventually replace the current one when it is complete.
(It does not yet respect tainting or max_ops, or report line numbers
correctly.) You can activate it by setting to 1 the ridiculously named
YES_I_WANT_JE_TO_OPTIMISE environment variable, which is just a
temporary hack that will later be removed.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/J*

%changelog
