%define module_name JIP-ClassField
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.051
Release: alt1
Summary: Create attribute accessor for hash-based objects
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLADIMIRZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Test::More;
    use JIP::ClassField;

    my $self = bless {}, __PACKAGE__;

    # Public access to the "foo"
    has('foo' => (get => '+', set => '+'));
    is($self->set_foo(42)->foo, 42);

    # Private access to the "bar"
    has('bar' => (get => '-', set => '-'));
    is($self->_set_bar(42)->_bar, 42);

    # Methods with user defined names
    has('wtf' => (get => 'wtf_getter', set => 'wtf_setter'));
    is($self->wtf_setter(42)->wtf_getter, 42);

    # Pass an optional first argument of setter to set
    # a default value, it should be a constant or callback.
    has('baz' => (get => '+', set => '+', default => 42));
    is($self->set_baz->baz, 42);

    has('qux' => (get => '+', set => '+', default => sub {
        my $self = shift;
        return $self->baz;
    }));
    is($self->set_qux->qux, 42);

    done_testing();
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/J*

%changelog
