# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Pod/Text.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name JSON-Types
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: variable type utility for JSON encoding
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TY/TYPESTER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The type mappings between JSON and Perl is annoying things. For example,

    use JSON;
    
    my $number = 123;
    
    warn "[DEBUG] number:$number\n" if $ENV{DEBUG};
    
    print encode_json([ $number ]);

Output of this code depends on whether DEBUG environment is set or not.
If set, result is `[123]'. If not to set, result is `["123"]'.
This is normal behaviour on Perl though, it sometimes causes unexpected JSON results.

There is a solution about this:

    print encode_json([ $number + 0 ]);

This code always outputs `[123]'.
But the code is a bit ugly and not readable at all.

This module provides some functions to fix this variable types issue:

    number $foo;  # is always number
    string $foo;  # is always string
    bool   $foo;  # is always bool

You can fix above code by using this module like this:

    use JSON;
    use JSON::Types;
    
    my $number = 123;
    
    warn "[DEBUG] number:$number\n" if $ENV{DEBUG};
    
    print encode_json([ number $number ]);



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/J*

%changelog
