# BEGIN SourceDeps(oneline):
BuildRequires: perl(Aniki.pm) perl(Carp.pm) perl(Cpanel/JSON/XS.pm) perl(Cpanel/JSON/XS/Type.pm) perl(DBD/SQLite.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Schema/DSL.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Mouse.pm) perl(Scalar/Util.pm) perl(Teng.pm) perl(Teng/Schema/Declare.pm) perl(Test2/V0.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name JSON-UnblessObject
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: unbless object using JSON spec like Cpanel::JSON::XS::Type
Group: Development/Perl
License: perl
URL: https://github.com/kfly8/p5-JSON-UnblessObject

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KF/KFLY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
JSON::UnblessObject is designed to assist with JSON encode.
For example, an blessed object can be encoded using JSON spec:

    my $json = Cpanel::JSON::XS->new->canonical;
    sub encode_json {
        my ($data, $spec) = @_;

        $data = unbless_object($data, $spec) if blessed $data;
        $json->encode($data, $spec)
    }

    encode_json($entity, { a => JSON_TYPE_INT });
    # => {"a":123}

    encode_json($entity, { b => JSON_TYPE_STRING });
    # => {"b":"HELLO"}

    encode_json($entity, { a => JSON_TYPE_INT, b => JSON_TYPE_STRING }),
    # => {"a":123,"b":"HELLO"}

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/J*

%changelog
