%define module_name JSON-XS-ByteString
Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.007
Release: alt2
Summary: Thin wrapper around fast JSON::XS that makes each JSON fields as string, and Perl fields as bytes (...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CI/CINDY/%{module_name}-%{version}.tar.gz

%description
This module is a wrapper around JSON::XS for making the life easier dealing with UTF-8 byte strings.

The added overhead is very low, you can try that your self ^^

The module try to achieve that by 3 approaches below:

=over 4

=item *
Transfer all the numeric values into strings before building the JSON string from Perl data

Because by the Perl nature, it's hard to determine if the outputted one is a string or numeric one.
The nondeterministic will make the life harder if the acceptor is writing in other languages
that strictly care about if it's string or number.

=item *
Transfer all the utf8 encoded octet into multibyte-char strings before encoding to JSON string.

If your situation is just like me that we all use utf8 encoded octet all around,
it's cumbersome and slow that we need to recursively upgrade all the string value into multibyte chars
before `JSON::XS::encode_json'.

=item *
Transfer all the multibyte-char strings into utf8 encoded octet after decoding JSON string
to Perl data.

If your situation is just like me that we all use utf8 encoded octet all around,
it's cumbersome and slow that we need to recursively downgrade all the string value back to utf8 encoded octet
after `JSON::XS::decode_json'.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/J*
%perl_vendor_autolib/*

%changelog
