%define module_name Jenkins-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(REST/Client.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Suite.pm) perl(Test2/Tools/Explain.pm) perl(Types/Standard.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: A wrapper around the Jenkins API
Group: Development/Perl
License: perl
URL: https://github.com/colinnewell/Jenkins-API

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEWELLC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a wrapper around the Jenkins API.  

    use Jenkins::API;

    my $jenkins = Jenkins::API->new({ base_url => 'http://jenkins:8080' });
    my $status = $jenkins->current_status();
    my @not_succeeded = grep { $_->{color} ne 'blue' } @{$status->{jobs}};
    # {
    #   'color' => 'red',
    #   'name' => 'Test-Project',
    #   'url' => 'http://jenkins:8080/job/Test-Project/',
    # }

    my $success = $jenkins->create_job($project_name, $config_xml);
    ...


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README example
%perl_vendor_privlib/J*

%changelog
