%define module_name Kafka
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(Authen/SCRAM.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Clone.pm) perl(Compress/LZ4Frame.pm) perl(Compress/Snappy.pm) perl(Config/IniFiles.pm) perl(Const/Fast.pm) perl(Cwd.pm) perl(Data/Compare.pm) perl(Data/Dumper.pm) perl(Data/HexDump/Range.pm) perl(Data/Validate/Domain.pm) perl(Data/Validate/IP.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Exception/Class.pm) perl(Exporter.pm) perl(File/HomeDir.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Gzip/Faster.pm) perl(IO/File.pm) perl(IO/Select.pm) perl(IO/Socket/INET.pm) perl(IO/Socket/IP.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Net/EmptyPort.pm) perl(PBKDF2/Tiny.pm) perl(Params/Util.pm) perl(Proc/Daemon.pm) perl(Proc/ProcessTable.pm) perl(Scalar/Util.pm) perl(Scalar/Util/Numeric.pm)
BuildRequires: perl(Socket.pm) perl(String/CRC32.pm) perl(Sub/Install.pm) perl(Sys/SigAction.pm) perl(Test/Deep.pm) perl(Test/Dist/VersionSync.pm) perl(Test/Distribution.pm) perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/Kwalitee/Extra.pm) perl(Test/MinimumVersion.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/NoWarnings.pm) perl(Test/Perl/Critic.pm) perl(Test/PureASCII.pm) perl(Test/Spelling.pm) perl(Test/Strict.pm) perl(Test/Synopsis.pm) perl(Test/TCP.pm) perl(Test/Vars.pm) perl(Test/Version.pm) perl(Time/HiRes.pm) perl(Try/Tiny.pm) perl(bigint.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.08
Release: alt1
Summary: Apache Kafka low-level synchronous API, which does not use Zookeeper.
Group: Development/Perl
License: perl
URL: https://github.com/TrackingSoft/Kafka

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AS/ASOLOVEY/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
The user modules in this package provide an object oriented API.
The IO agents, requests sent, and responses received from the Apache Kafka
or mock servers are all represented by objects.
This makes a simple and powerful interface to these services.

The main features of the package are:

=over 3

=item *

Contains various reusable components (modules) that can be used separately
or together.

=item *

Provides an object oriented model of communication.

=item *

Supports parsing the Apache Kafka Wire Format protocol.

=item *

Supports the Apache Kafka Requests and Responses (PRODUCE and FETCH with
no compression codec attribute now). Within this package we currently support
access to the PRODUCE Request, FETCH Request, OFFSETS Request, FETCH Response,
OFFSETS Response.

=item *

Simple producer and consumer clients.

=item *

Simple mock server instance for testing without Apache Kafka server.

=item *

Support for working with 64 bit elements of the Kafka Wire Format protocol
on 32 bit systems.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/K*

%changelog
