# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Kelp.pm) perl(Module/Loader.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name KelpX-Controller
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Base custom controller for Kelp
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRTASTIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Since Kelp *2.16* it's quite easy to introduce your own base controller class
instead of subclassing the main application class.

This extension is a more modern approach to route handling, which lets you have
a proper hierarchy of custom classes which serve as controllers. Enabling it is
easy, and can be done as shown in the SYNOPSIS entry elsewhere in this document.

The controller will be built just like a regular object the first time it's
used. It will not be cleared after the request, since the context object will
have its `persistent_controllers' set to true by default. You may override
the build entry elsewhere in this document in the controller, but if you want to have it add any routes then you
will have to instantiate it manually using `$app->context->controller'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/K*

%changelog
