# BEGIN SourceDeps(oneline):
BuildRequires: libkeyutils-devel perl(Carp.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Kernel-Keyring
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt5
Summary: Wrapper for kernel keyring syscalls
Group: Development/Perl
License: perl
URL: https://github.com/lixmal/Kernel-Keyring

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LI/LIXMAL/%{module_name}-%{version}.tar.gz

%description
the Kernel::Keyring manpage is a rudimentary wrapper for libkeyutils based syscalls.
Provided functions should suffice for the typical use case: storing passwords/keys in a secure location, the kernel.
Data stored in the kernel keyring doesn't get swapped to disk (unless big_key type is used) and it can automatically time out.

A general overview of the keyring facility is given here: http://man7.org/linux/man-pages/man7/keyrings.7.html

More documentation is available on the man page of keyctl http://man7.org/linux/man-pages/man1/keyctl.1.html


Module exports all functions by default.

All functions "die" with a proper message on errors.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_archlib/K*
%perl_vendor_autolib/*

%changelog
