Epoch: 1
%define module_name LIMS-MT_Plate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Microarray.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt2
Summary: A Perl module for creating and manipulating micro-titre plate objects
Group: Development/Perl
License: perl
URL: https://github.com/vlyon/LIMS-MT_Plate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLYON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
LIMS::MT_Plate is a Perl module for creating and manipulating microtitre plate objects. It defines a Class of MT_Plate for each microtitre format, which include variables specific to the format and methods that are common to all. .
The most common use of MT_Plate is to enable the consistent assignment of multiple samples to wells of a microtitre plate while ensuring the plate layout is valid for the specified format, and also to more easily manage the transfer of samples from plate to plate. 

MT_Plate currently supports 96, 384 and 1536 well plate formats, as well as an individual tube, and provides methods for filling individual wells, and multiple wells. The filling of multiple wells supports either row-by-row (i.e. A1=sample1, A2=sample2, etc) or column-by-column ordering (i.e. A1=sample1, B1=sample2, etc), depending on the name format of the wells passed to the method `fill_wells()' as described in the examples above. 

The identity of a sample in a single well can be returned, or alternatively all of the samples in the plate can be exported as a reference to an array. Similar to the filling of wells, the order of the samples returned in the array can be either row-by-row, or col-by-col, as described in the examples above. 

What the module won't do is re-order samples in a plate. The reasons for this might not be obvious to someone who doesn't work in a laboratory - but if you don't want to contaminate your samples that's basically a no-no. What you would do instead is transfer the samples from one plate to another, re-ordering them as you do so - and that's what you should do if you use MT_Plate. 


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/L*

%changelog
