%define module_name LMDB_File
# BEGIN SourceDeps(oneline):
BuildRequires: liblmdb-devel libsowing-devel perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Tie to LMDB (OpenLDAP's Lightning Memory-Mapped Database)
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SO/SORTIZ/%{module_name}-%{version}.tar.gz

%description
NOTE: This document is still under construction. Expect it to be
incomplete in places.

LMDB_File is a Perl module which allows Perl programs to make use of the
facilities provided by the OpenLDAP's Lightning Memory-Mapped Database "LMDB".

LMDB is a Btree-based database management library modeled loosely on the
BerkeleyDB API, but much simplified and extremely fast.

It is assumed that you have a copy of LMBD's documentation at hand when reading
this documentation. The interface defined here mirrors the C interface closely
but with an OO approach.

This is implemented with a number Perl classes.

A LMDB's environment handler (MDB_env* in C) will be wrapped in the
LMDB::Env class.

A LMDB's transaction handler (MDB_txn* in C) will be wrapped in the
LMDB::Txn class.

A LMDB's cursor handler (MDB_cursor* in C) will be wrapped in the
LMDB::Cursor class.

A LMDB's DataBase handler (MDB_dbi in C) will be wrapped in an opaque SCALAR,
but because in LMDB all DataBase operations needs both a Transaction and a
DataBase handler, LMDB_File will use a LMDB_File object that encapsulates both.



%prep
%setup -q -n %{module_name}-%{version}
sed -i -e s,/686/,/11111111111111111/, Makefile.PL

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes TODO README
%perl_vendor_archlib/L*
%perl_vendor_autolib/*

%changelog
