# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(OpenOffice/OODoc.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name LW4-Reader
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension for reading Lightwright 4 files.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TA/TAMBASCOT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is designed to read basic information out of a file generated.by John McKernon's "Lightwright 4" software. At the time of this writing,
Lightwright is not available for POSIX compliant operating systems, and
these functions are convenient to use for the purpose of converting the
basic item info of a Lightwright file into a spreadsheet (or some other
data format).

=over

=item read_header($file_handle)

This subroutine reads the header information out of an open file handle and
returns it as a hashref. Access as follows:

my $lw4_header = read_header($file_handle);

$lw4_header->{save_date};        # The date the file was last saved.
$lw4_header->{save_time};        # The time the file was last saved.
$lw4_header->{show_name};        # The name of the show.
$lw4_header->{sub_head_1};       # File sub heading 1.
$lw4_header->{sub_head_2};       # File sub heading 2.
$lw4_header->{sub_head_3};       # File sub heading 3.
$lw4_header->{sub_head_4};       # File sub heading 4.
$lw4_header->{sub_head_5};       # File sub heading 5.
$lw4_header->{sub_head_6};       # File sub heading 6.
$lw4_header->{num_fixtures};     # Current number of fixtures in the file.
$lw4_header->{max_num_fixtures}; # The maximum number of fixtures the file
                                 # has had.
$lw4_header->{file_ident};       # The unique identifier for the file.

=item read_item_info($file_handle)

This subroutine reads the items out of an open file handle and returns a ref
to an array of hashes. The items are read into a hashref, and then stored
sequentially in an array, the ref to which is returned to caller. Access to
item info is as follows:

my $lw4_info = read_item_info($file_handle)

$lw4_info->[0]->{channel};      # The channel the item is assigned to.
$lw4_info->[0]->{dimmer};       # The dimmer the item is assigned to.
$lw4_info->[0]->{unit};         # The unit number of the item.
$lw4_info->[0]->{watts};        # The wattage of the item.
$lw4_info->[0]->{circuit};      # The circuit number of the item.
$lw4_info->[0]->{purpose};      # The purpose of the item.
$lw4_info->[0]->{position};     # The hang position of the item.
$lw4_info->[0]->{color};        # The gel color of the item.
$lw4_info->[0]->{type};         # The fixture type of the item.
$lw4_info->[0]->{pattern};      # The pattern the item carries.
$lw4_info->[0]->{item_key};     # The unique key identifier of the item,
                                # generated by Lightwright.

There are several pieces of information that Lightwright stores for each item
that have not yet been identified. They are presently stored in the hash,
and are accessable: if you know what one of these is, see the code for which
unknown type you're looking for, and please drop the author an email so he
can update the software accordingly.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*
%changelog
