Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-LWP-Authen-Wsse
Version:        0.05
Release:        alt2_49
Summary:        Library for enabling X-WSSE authentication in LWP

License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/LWP-Authen-Wsse
Source0:        https://cpan.metacpan.org/authors/id/A/AU/AUTRIJUS/LWP-Authen-Wsse-%{version}.tar.gz
# Make system Module::Install to work with this package, CPAN RT#58518
Patch0:         LWP-Authen-Wsse-0.05-Work-around-Module-Install-only-supports-5.005-bug.patch

BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Digest/SHA1.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(MIME/Base64.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test.pm)
Source44: import.info

%description
LWP::Authen::Wsse allows LWP to authenticate against servers that are 
using the X-WSSE authentication scheme, as required by the Atom 
Authentication API.

%prep
%setup -q -n LWP-Authen-Wsse-%{version}
%patch0  -p1
# Remove bundles modules
rm -rf inc
sed -i -e '/^inc\//d' MANIFEST


%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
chmod -R u+w $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes README
%{perl_vendor_privlib}/*


%changelog
