# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Net/Netmask.pm) perl(Socket.pm) perl(Time/Local.pm)
# END SourceDeps(oneline)
%define module_version 1.36
%define module_name LaBrea-Tarpit
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.36
Release: alt1
Summary: Utilities and web displays for 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
- LaBrea::Tarpit.
A comprehensive Hack Attack reporting module when used in conjunction with
Tom Liston's LaBrea scanner/worm disruptor. When configured with reporting
and stat collection it provides a detailed HTML page containing:

=over 4

=item * Bandwidth consumed by attack/disruption daemon

=item * Summary of previous 5 days of attack/disruption

=item * All IP addresses currently attacking

=item * IP address, port attacked/held, attack start time

=item * As above, but history of terminated attacks

=item * By day detail graphs on port attack intensity

=item * Active summary of known LaBrea::Tarpit sites

=back

For more information on LaBrea see: http://sourceforge.net/projects/labrea/ 
or contact the author of LaBrea, Tom Liston the tliston@hackbusters.net entry elsewhere in this document.

The parsed output of either syslog data or STDOUT from LaBrea using -o or -O
options is readily turned into text reports or an html output page.

Basically there are two methods of operation. You can use the daemon mode
to create an almost realtime cache that may be parsed using the report
routines, or you can use the update and report routines to parse the syslog
files on an as needed basis. If you plan to create web page reports, the
daemon model will use less system resources in the long run and avoids
running syslog with the high volume output of LaBrea.

Improvements VERSION 1.00

As of version 1.00, daemon.pl uses network sockets to provide data for
the report modules. This means that the daemon can run on a remote machine
and the report scripts and web server can be somewhere else.

For those of you upgrading from older versions, you MUST upgrade all of
your report scripts as well. Older versions use a pipe or FIFO and this is
no longer supported as there were problems maintaining separate sessions.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*
%changelog
