# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Slurp.pm) perl(LaTeX/Driver.pm) perl(LaTeX/Table.pm) perl(Test/Kwalitee.pm) perl(Test/Perl/Critic.pm) perl(charnames.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: texlive-latex-recommended
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    LaTeX-Encode
%define upstream_version 0.092.0

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Encode LaTeX special chars for typesetting
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/LaTeX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp/Always.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(HTML/Entities.pm)
BuildRequires: perl(Pod/LaTeX.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Readonly.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This module provides a function to encode text that is to be formatted with
LaTeX. It encodes characters that are special to LaTeX or that are
represented in LaTeX by LaTeX commands.

The special characters are: '\' (command character), '{' (open group), '}'
(end group), '&' (table column separator), '#' (parameter specifier), '%'
(comment character), '_' (subscript), '^' (superscript), '~' (non-breakable
space), '$' (mathematics mode).

Note that some of the LaTeX commands for characters are defined in the
LaTeX 'textcomp' package. If your text includes such characters, you will
need to include the following lines in the preamble to your LaTeX document.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README TODO
%{_bindir}/*
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
