# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Compare.pm) perl(File/Path.pm) perl(Test/More.pm) perl(Test/More/UTF8.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name LaTeX-Replicase
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.031
Release: alt1
Summary: Perl extension implementing a minimalistic engine for filling real TeX-LaTeX files that act as temp...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DONANGEL/LaTeX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a Perl 5 extension implementing Replicase subroutines which processes TeX-LaTeX files, 
interpreting and executing built-in control directives (tags) of Replicase.

Replicase can: define and substitute variable values, execute conditional actions and capture 
the resulting output into a new document.
Replicase was originally designed for creating programmatically configurable TeX-LaTeX documents.

Unlike other template engines, here the logic and cycles are completely separated from TeX-LaTeX document
and are moved to your Perl program using this module. It's well suited for this and similar tasks,
allowing you to dynamically create PDF documents that are consistent with each other, yet easily customisable.

Replicase is a standalones, safe as a TeX-LaTeX, and fast template engine with remarkable features.
All markup is based on following "three pillars" (directives, tags):

=over 3

=item *
 `%%%%%%V: variable_name'  is a short form of a regular (SCALAR) *variable_name*
that completely replaces the string in which it is located, e.g.

  Blah, blah, \ldots blah. %%%%%%V: myParam

will be completely replaced by contents of `myParam' variable.

It can be nested in an ARRAY or HASH `%%%%%%VAR:' tag,
but in SCALAR `%%%%%%VAR:' it will not work and will be discarded.

=item *
 `%%%%%%VAR: variable_name'  is start of full form of regular (SCALAR) or complex (ARRAY, HASH) *variable_name*,
preserving preceding TeX up to %%%%%%VAR: but completely replacing everything up to first `%%%%%%END:' tag inclusive.

  Blah, blah, \ldots blah. %%%%%%VAR: myParam
  Blah, blah, \ldots
  \ldots

  Blah, \ldots %%%%%%END:

Usually ARRAY and HASH *variable_name* are used in the template to create (fill) tables.

CONCLUSION: Nested `%%%%%%VAR:' tags will not work and will be discarded.

=item *
 `%%%%%%END:'  is used to specify the end of `%%%%%%VAR:' tag.
Text located in line with `%%%%%%END:' will be discarded.

BTW: If this tag is omitted, all text to the end of document will be replaced 
by `variable_name' specified in `%%%%%%VAR:' tag.

=back

The fol...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
