%define module_name Language-FormulaEngine
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Format/Flexible.pm) perl(Devel/Gladiator.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(MRO/Compat.pm) perl(Math/Trig.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(POSIX.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Sub/Util.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/V0.pm) perl(Try/Tiny.pm) perl(integer.pm) perl(namespace/clean.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Evaluator for spreadsheet-style function expressions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This set of modules implement a parser, evaluator, and optional code generator for a simple
expression language similar to those used in spreadsheets.
The intent of this module is to help you add customizable behavior to your applications that an
"office power-user" can quickly learn and use, while also not opening up security holes in your
application.

In a typical business application, there will always be another few use cases that the customer
didn't know about or think to tell you about, and adding support for these use cases can result
in a never-ending expansion of options and chekboxes and dropdowns, and a lot of time spent
deciding the logical way for them to all interact.
One way to solve this is to provide some scripting support for the customer to use.  However,
you want to make the language easy to learn, "nerfed" enough for them to use safely, and
prevent security vulnerabilities.  The challenge is finding a language that they find familiar,
that is easy to write correct programs with, and that dosn't expose any peice of the system
that you didn't intend to expose.  I chose "spreadsheet formula language" for a project back in
2012 and it worked out really well, so I decided to give it a makeover and publish it.

The default syntax is pure-functional, in that each operation has exactly one return value, and
cannot modify variables; in fact none of the default functions have any side-effects.  There is
no assignment, looping, or nested data structures.  The language does have a bit of a Perl twist
to it's semantics, like throwing exceptions rather than returning `#VALUE!', fluidly
interpreting values as strings or integers, and using the DateTime manpage instead of days-since-1900
numbers for dates, but most users probably won't mind.  And, all these decisions are fairly
easy to change with a subclass.
(but if you want big changes, you should review your options to make sure you're
starting with the right module.)

The language is written with security in mind, and (until you start making cha...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/L*

%changelog
