# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.012
%define module_name Language-RAM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.012
Release: alt1
Summary: A "Random Access Machine" Emulator
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DE/DEPRINT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides a library and an interpreter to emulate a basic
"Random Access Machine". This computer model uses an assembler-like syntax
and can be used to test simple algorithms for their complexity.

You can use `ram.pl' to run Random Access Machines and get
extensive information on memory usage, memory changes and complexity.
See `ram.pl --help' for details.

    use Language::RAM;

    my $input = "INPUT 0\nOUTPUT 1\na <-- s[0]\na <-- a * s[0]\ns[1] <-- a\nHALT";

    my %%machine = Language::RAM::asl($input);
    die "$machine{'error'}" if ($machine{'error'} ne '');

    my $ret = Language::RAM::run(\%%machine, [8]); # Returns 8^2
    if($ret) {
      print STDERR "Error from machine: $machine{'error'}\n";
    }

    my %%output = Language::RAM::get_output(\%%machine);
    print "OUTPUT FROM MACHINE:\n";
    foreach (sort { $a <=> $b } keys %%output) {
      printf "%%4d=%%d\n", $_, $output{$_} // 0;
    }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%files scripts
%_bindir/*

%changelog
