%define module_name Lexical-Failure
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/Util/FieldHash.pm) perl(Keyword/Simple.pm) perl(Scope/Upper.pm) perl(Test/Effects.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001001
Release: alt1
Summary: User-selectable lexically-scoped failure signaling
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCONWAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module sets up two new keywords: `fail' and `ON_FAILURE',
with which you can quickly create modules whose failure signaling
is lexicially scoped, under the control of client code.

Normally, modules specify some fixed mechanism for error handling and
require client code to adapt to that policy. One module may signal
errors by returning `undef', or perhaps some special "error object".
Another may `die' or `croak' on failure. A third may set a flag
variable. A fourth may require the client code to set up a callback,
which is executed on failure.

If you are using all four modules, your own code now has to check for
failure in four different ways, depending on where the failing
component originated. If you would rather that *all* components throw
exceptions, or all return `undef', you will probably have to write
wrappers around 3/4 of them, to convert from their "native" failure
mechanism to your preferred one.

Lexical::Failure offers an alternative: a simple mechanism with which
module authors can generically specify "fail here with this message"
(using the `fail' keyword), but then allow each block of client
code to decide how that failure is reported to it within its own lexical
scope (using the `ON_FAILURE' keyword).

Module authors can still provide a default failure signaling mechanism,
for when client code does not specify how errors are to be reported.
This is handy for ensuring backwards compatibility in existing modules
that are converted to this new failure signaling approach.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
