# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define module_version 0.13
%define module_name License-Syntax
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Coding and Decoding of License strings using SPDX and SUSE syntax.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JN/JNW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This implements the SUSE License Syntax.

    use License::Syntax;

    my $obj = new License::Syntax licensemap => 'licenselist.csv;as';
    my $obj = new License::Syntax map => { 'GNU General Public License V2.0' => 'GPLv2' };
    my $obj = new License::Syntax 'pathname.sqlite;table(alias,name)';
    $obj->loadmap_csv($filename_csv);
    $obj->loadmap_sqlite($filename_sqlite, $table_name, $alias_col, $name_col);
    $obj->savemap_csv($filename_csv, scalar(localtime));
    $obj->savemap_sqlite($filename_sqlite, $table_name, $alias_col, $name_col, 'TRUNCATE');
    $obj->add_alias($alias, $canonical_name);
    $name = $obj->canonical_name($alias, $disambiguate);
    $tree = $obj->tokenize('GPLv2 & Apache 1.1; LGPLv2.1 | BSD4c<<ex(UCB); Any Noncommercial', $disambiguate);
    $name = $obj->format_tokens($tree);



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc license_map.csv license_syntax.pl Changes README
%perl_vendor_privlib/L*

%changelog
