# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/Round.pm) perl(Moose.pm) perl(Package/Alias.pm) perl(Params/Check/Item.pm) perl(Test/CheckManifest.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name LinAlg-Vector
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Extensive vector library based on Moose class system.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SS/SSTEFFL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
LinAlg::Vector proveds an object-oriented interface for creating and using 
vectors composed of numbers. It supports most mathematical functions such
as add, subtract, dot, cross, scale, unit, and projection. Additionally,
convenience functions for comparing vectors, and stringifying them are
also provided.

All vector methods, except for `set', will not modify the underlying 
vector -- they all will return new vectors.

An example of performing the triple-product of three vectors:

    use LinAlg::Vector;

    my $v1 = LinAlg::Vector->new([1,2,3]);
    my $v2 = LinAlg::Vector->new([4,5,6]);
    my $v3 = LinAlg::Vector->new([7,8,9]);
    my $s1 = $v1->dot($v2->cross($v3));

%prep
%setup -q -n %{module_name}-%{version}
rm -f t/[0-9][-_]signature.t t/[0-9][0-9][-_]signature.t t/[0-9]signature.t t/[0-9][0-9]signature.t t/signature.t
rm -f t/[0-9][-_]Signature.t t/[0-9][0-9][-_]Signature.t t/[0-9][0-9][0-9][-_]Signature.t t/[0-9]Signature.t t/[0-9][0-9]Signature.t t/[0-9][0-9][0-9]Signature.t t/Signature.t
rm -f t/[0-9][-_]manifest.t t/[0-9][0-9][-_]manifest.t t/[0-9][0-9][0-9][-_]manifest.t t/[0-9]manifest.t t/[0-9][0-9]manifest.t t/[0-9][0-9][0-9]manifest.t t/manifest.t
rm -f t/[0-9][-_]MANIFEST.t t/[0-9][0-9][-_]MANIFEST.t t/[0-9][0-9][0-9][-_]MANIFEST.t t/[0-9]MANIFEST.t t/[0-9][0-9]MANIFEST.t t/[0-9][0-9][0-9]MANIFEST.t t/MANIFEST.t
rm -f t/[0-9][-_]check_manifest.t t/[0-9][0-9][-_]check_manifest.t t/[0-9][0-9][0-9][-_]check_manifest.t t/[0-9]check_manifest.t t/[0-9][0-9]check_manifest.t t/[0-9][0-9][0-9]check_manifest.t t/check_manifest.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/L*

%changelog
