# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class/Schema/Loader.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Lingua/Stem.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Text/CSV_XS.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Lingua-EN-AffectiveNorms
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl based data store for the ANEW - standardised
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZA/ZARQUON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides data store and retrieval to assess the emotional content.of text based on a standardised list of english words.  It has use in some text
mining procedures (e.g. see ACKNOWLEDGEMENTS section).

DBIx::Class schema (dynamic) to load list of english affective words from
http://csea.phhp.ufl.edu/media/anewmessage.html

 my $schema    = Lingua::EN::AffectiveWords->connect; # db lives in same dir as package by default
 my $all_rs    = $schema->resultset(AllSubjects);
 my $male_rs   = $schema->resultset(Male);
 my $female_rs = $schema->resultset(Female);

The list of words is a bit tricky to obtain (see link above), so this module comes with a blank database stored in the same dir as the .pm file, with the following schema:

 create table all_subjects (
 word varchar(32),
 word_stem varchar(32),
 word_no integer,
 valence_mean float,
 valence_sd float,
 arousal_mean float,
 arousal_sd float,
 dominance_mean float,
 dominance_sd float,
 word_freq float,
 primary key(word)
 );

 create table male (
 word varchar(32),
 word_stem varchar(32),
 word_no integer,
 valence_mean float,
 valence_sd float,
 arousal_mean float,
 arousal_sd float,
 dominance_mean float,
 dominance_sd float,
 word_freq float,
 primary key(word)
 );

 create table female (
 word varchar(32),
 word_stem varchar(32),
 word_no integer,
 valence_mean float,
 valence_sd float,
 arousal_mean float,
 arousal_sd float,
 dominance_mean float,
 dominance_sd float,
 word_freq float,
 primary key(word)
 );

The next thing is to put the male, female and all_subjects lists into separate
csv files, with the headibngs as for the column names in the database, then run
the following perl script on it (also available in the examples dir of the
distribution).

 #!/usr/bin env perl
 use warnings;
 use strict;
 use Text::CSV_XS;
 my $csv = Text::CSV_XS->new;

 use Lingua::Stem qw/stem/;

 my ($infile, $table) = @ARGV or die "infile and table name required";
 die "table should be AllSubjects, Male or Female" unless table ~ /^(AllSubjects|Male|Female)$/)
 my $schema = Lingua::EN::AffectiveNorms::Schema->connect;
 my $rs = $schema->resultset($table);

 open my $IN, "<", $infile;
 my @header;
 while (<$IN>) {
     $csv->parse($_);
     my @row = $csv->fields;
     if ($. == 1) {
         @header = @row;
     }
     else {
         my %%data;
         @data{@header} = @row;
         $data{word_stem} = stem($data{word})->[0];
         $rs->create(\%%data);
     }
 }

I'd distribute the databse with this module, except that the distribution
conditions of the word list preclude this.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*
%changelog
