%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(Lingua/EN/Tagger.pm) perl(List/Util.pm) perl(WordNet/QueryData.pm) wordnet-dict
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Lingua-EN-Semtags-Engine
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: extract semantic tags (semtags) from English text 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IG/IGORM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Lingua::EN::Semtags uses Lingua::EN::Tagger and WordNet::QueryData to extract 
semantic tags (semtags) from English text.  Semtags are words which reflect 
the semantic essence of the text (similar to topic keywords).

Lingua::EN::Semtags was designed and developed to solve a particular problem I 
was facing.

Problem: a user is processing blog post titles and needs to programmatically 
determine the posts' semantic context.

Solution: the user feeds a blog post title to Lingua::EN::Semtags and gets 
back a set of semtags which can be used for further processing (e.g., web 
searches).

Example: a blog post title like "BBtv: Graffiti Research Lab, the movie" 
(boingboing.net, Posted by Xeni Jardin, April 24, 2008 8:00 AM) would produce 
the following semtags: [DECORATION WORKPLACE SHOW].

Please note that the module makes the following assumptions when attempting to 
extract semtags:

=over 4

=item *

only nouns, verbs, adjectives and adverbs are considered as candidate words 
for semtags; 

=item *

at the time of phrase detection a frame is grown up to PHRASE_FRAME_SIZE 
(set to 3) tokens;

=item *

a language unit (a word or a phrase) is considered meaningful if its hypernym 
hierarchy in the WordNet database is at least MIN_ISAS (set to 3) levels deep;

=item *

a semtag is a meaningful language unit's hypernym at the SEMTAG_ISA_INDEX (set 
to 1, starts with 0) level of the hierarchy.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/L*

%changelog
