# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Lingua-EN-TitleParse
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Parse titles in people's names
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PJ/PJA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module parses strings containing people's names to identify
titles, like "Mr", "Mrs", etc, so the names and titles can be separated.

e.g. "Mr Joe Bloggs" will be parsed to "Mr", and "Joe Bloggs".

The module handles "fuzziness" such as changes of case and punctuation
characters: "Mr", "MR", "Mr.", and "mr" will all be recognised correctly.

It differs from another CPAN module, Lingua::EN::NameParse, in two key
respects:

Firstly, Lingua::EN::TitleParse performs well irrespective of the
number of titles being matched against.  While Lingua::EN::NameParse
loops through a series of regular expressions, and suffers when the set
of titles being matched is long, Lingua::EN::TitleParse uses hash-lookups
after "normalising" each name string, providing consistently good
performance.

Secondly it's only focused on parsing titles in names, whereas
Lingua::EN::NameParse attempts much more.  However the extra
intelligence of Lingua::EN::NameParse can come at the cost of
predictablity. Lingua::EN::TitleParse is more conservative, and
by default makes no changes to the case or content (with the exception
of compressing extra white-space) of what was input, effectively
only splitting the input string in two. (But that said, there is an
option to output cleaned titles).

We're using the same titles Lingua::EN::NameParse uses (their "extended set")
with minor additions, but your own set of titles can be imported instead.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/L*

%changelog
