%define module_name Lingua-Han-Utils
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/Detect/CJK.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt2
Summary: The utility tools of Chinese character(HanZi)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FA/FAYLAND/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Lingua::Han::Utils qw/Unihan_value csplit cdecode csubstr clength/;

    # cdecode
    # the same as decode('cp936', $word) in ASCII editing mode
    #         and decode('utf8', $word) in Unicode editing mode
    my $word = cdecode($word);

    # Unihan_value
    # return the first field of Unihan.txt on unicode.org
    my $word = ".''";
    my $unihan = Unihan_value($word); # return '6211'
    my $words = ".'N.Ao";
    my @unihan = Unihan_value($word); # return (7231, 4F60)
    my $unihan = Unihan_value($word); # return 72314F60

    # csplit
    # split the Chinese characters into an array
    my $words = ".''.'N.Ao";
    my @words = csplit($words); # return (".''", ".'N", ".Ao")

    # csubstr
    # treat the Chinese characters as one
    # so it's the same as splice(csplit($words), $offset, $length)
    my $words = ".''.'N.Ao.''";
    my @words = csubstr($words, 1, 2); # return (".'N", ".Ao")
    my @words = csubstr($words, 1); # return (".'N", ".Ao", ".''")
    my $words = csubstr($words, 1, 2); # .'N.Ao

    # clength
    # treat the Chinese character as one
    my $words = ".''.'N.Ao";
    print clength($words); # 3

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
