# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Lingua/JA/Name/Splitter.pm) perl(List/Util.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Unicode/Normalize.pm) perl(charnames.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Lingua-NameUtils
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: Identify given/family names and capitalize correctly
Group: Development/Perl
License: perl
URL: https://metacpan.org/dist/Lingua-NameUtils

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RA/RAFORG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is useful when receiving a person's name that might be all
uppercase, or in the wrong case, or it might have the given names and the
family name combined in a single string (e.g., a single spreadsheet column),
and you need to split the full name into its parts, and you want to set the
capitalization correctly so as to show each person a little respect by
taking the trouble to at least try to get their name right.

Getting the case right for people's names is difficult, and many software
systems address this problem by not even trying, and using uppercase
exclusively. It's ugly, but it's easy and consistent. We can do better. It
can't be perfect, by default, but with ongoing adjustments to suit your
evolving dataset, you can improve it to meet your needs.

People with complex grammatical aristocratic/topographic/patronymic family
names often don't know how their own names should be capitalized. Or at
least, they don't know how their own ancestors capitalized their name, or
they know, but they disagree with it. Some people insist on having it their
own way, and that's fine. This module, by default, prefers how their
ancestors would have capitalized their names, but people can do whatever
they want to their own names, and it's important to them, so this module
supports general exceptions that apply to everyone with a particular family
name, for when the default behaviour is definitely wrong, and it also
supports exceptions that apply only to individuals who report that it is
wrong for them.

Note: This module doesn't handle every name on Earth. Apart from Chinese,
Japanese, and Korean family names, it only understands names written in
Latin scripts, except perhaps by lucky accident. For example, names in
Cyrillic work. It doesn't handle honorifics, titles, joined initials, or
postnominals. It only handles names. But it does handle complex names coming
from a variety of places (e.g., British Isles, Europe, Middle East, Africa,
East Asia, Pacifika, Americas). By default, it doesn't correctly identi...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/L*

%changelog
