%define module_name Lingua-Sentence
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.100
Release: alt1
Summary: Perl extension for breaking text paragraphs into sentences
Group: Development/Perl
License: lgpl
URL: https://github.com/achimr/corpus-tools

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CA/CAPOEIRAB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows splitting of text paragraphs into sentences. It is based on scripts developed by Philipp Koehn and Josh Schroeder for processing the Europarl corpus (http://www.statmt.org/europarl/).

The module uses punctuation and capitalization clues to split paragraphs into an newline-separated string with one sentence per line. For example:

_This is a paragraph. It contains several sentences. "But why," you ask?

goes to:

_This is a paragraph.
_It contains several sentences.
_"But why," you ask?

Languages currently supported by the module are:

=over


=item Catalan

=item Czech

=item Dutch

=item English

=item French

=item German

=item Greek

=item Hungarian

=item Icelandic

=item Italian

=item Latvian

=item Polish

=item Portuguese

=item Russian

=item Spanish

=item Slovak

=item Slovenian

=item Swedish

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CONTRIBUTING.md README Changes
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*
%changelog
