# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Cycle.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.16
%define module_name Lingua-Treebank
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Perl extension for manipulating the Penn Treebank format
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KA/KAHN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This class knows how to read two treebank formats, the Penn format and
the Chomsky Normal Form (CNF) format.  These formats differ in how
they handle terminal nodes.  The Penn format places pre-terminal part
of speech tags in the left-hand position of a parenthesis-delimited
pair, just like it does non-terminal nodes.  The CNF format attaches
pre-terminal tags to the word with an underscore.  For example, the
sentence "I spoke" would be rendered in each format as follows:

    (S
        (NP
            (N I))
        (VP
            (V spoke)))
            Penn

    (S
        (NP
            I_N)
        (VP
            spoke_V))
     Chomsky Normal Form

Almost all the interesting tree-functionality is in the
constituent-forming package (included in this distribution, see
the Lingua::Treebank::Const manpage).

PLEASE NOTE: The format expected here is the `.mrg' format, not the
`.psd' format.  In other words, one POS-tag per word is required. (In
response to CPAN bug 15079.)

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/L*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
