# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name Lingua-ZH-HanConvert
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: convert between Traditional and Simplified Chinese characters
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DI/DIVEC/%module_name-%module_version.tgz
BuildArch: noarch

%description
In the 1950's, the Chinese government simplified over 2000 Chinese
characters.  Taiwan and Hong Kong still use the traditional characters.
The simplified characters are hard to read if you only know the traditional
ones, and vice-versa.  This module attempts to convert Chinese text between
the two forms, using character-by-character transliteration.

Note that this module only handles text in the Unicode UTF-8 character set.
If you need to convert between the Big5 and GB character sets, then please
look at the Text::IConv manpage, or use the `HanConvert' Perl script which comes
with this module.

`simple' takes a string, converts any traditional Chinese characters (such
as E<22283>, unicode U+570B, meaning "country") to the corresponding
simplified characters (like E<22269>, unicode U+56FD, also meaning
"country"), and returns the result.  Characters which are not traditional
Chinese do not change.

`trad' does the reverse; it converts any simplified Chinese characters to
the corresponding traditional characters.  Characters which are not
simplified Chinese do not change.

If a simplified character has two or more corresponding traditional
characters, then it will be replaced by all of them, enclosed in square
brackets.  To use different characters instead of the square brackets, give
them as the second and third arguments to `trad'.  The same applies where
a traditional character has two or more corresponding simplified forms,
but this happens much more rarely.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc ChangeLog README
%perl_vendor_privlib/L*

%files scripts
%_bindir/*

%changelog
