# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Encode.pm) perl(Event.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Linux-DVB
%define upstream_version 1.03

%{?perl_default_filter}

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt5_15

Summary:	Interface to (some parts of) the Linux DVB API
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/Linux/%{upstream_name}-%{upstream_version}.tar.gz
Patch0:		remove_unused_defs.patch
BuildRequires:	perl(Canary/Stability.pm)
BuildRequires:	perl-devel
Source44: import.info


%description
This module provides an interface to the Linux DVB API. It is a
straightforward translation of the C API. You should read the Linux DVB API
description to make any sense of this module. It can be found here:

   https://linuxtv.org/docs/dvbapi/dvbapi.html

All constants from _frontend.h_ and _demux.h_ are exported by their C name
and by default.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch0 -p1


%build
export PERL_CANARY_STABILITY_NOPROMPT=1
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc README Changes META.yml
%perl_vendor_archlib/*


%changelog
