%define module_version 0.17
%define module_name Linux-LVM
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Perl extension for accessing Logical Volume Manager(LVM)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RA/RAYMOR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
units()  Get or set the units used to report sizes of LVs, PVs, etc..           legal values: hbskmgtpeHBSKMGTPE
           see man lvm documentation of --units
 
  get_volume_group_list()	This routine will return an array that
				contains the names of the volume groups.

  @vgs = get_volume_group_list(); print "@vgs \n"; 
  Would yield the following: vg00
   
    
  get_volume_group_information($)	This routine will return all of
					the volume group information about
					the specified volume group.

  %%vg = get_volume_group_information("vg00");
  foreach(sort keys %%vg) {
     print "$_ = $vg{$_}\n";
  }
  Would yield the following:
     access = read/write
     act_pv = 2
     alloc_pe = 3840
     alloc_pe_size = 15
     alloc_pe_size_unit = GB
     cur_lv = 3
     cur_pv = 2
     free_pe = 864
     free_pe_size = 3.38
     free_pe_size_unit = GB
     max_lv = 256
     max_lv_size = 255.99
     max_lv_size_unit = GB
     max_pv = 256
     open_lv = 0
     pe_size = 4
     pe_size_unit = MB
     status = available/resizable
     total_pe = 4704
     uuid = BBq8si-NyRR-9ZNW-3J5e-DoRO-RBHK-ckrszi
     vg_number = 0
     vg_size = 18.38
     vg_size_unit = GB
     vgname = vg00
   
  
  get_logical_volume_information($)	This routine will return all of the
					logical volume information associated
					with the specified volume group.
 
  %%lv = get_logical_volume_information("vg00");
  foreach $lvname (sort keys %%lv) {
      foreach(sort keys %%{$lv{$lvname}}) {
          print "$_ = $lv{$lvname}->{$_}\n"; 
      }
      print "\n"; 
  }
  Would yield the following results:
  alloc_le = 1024
  allocation = next free
  cur_le = 1024
  device = 58:0
  lv_number = 1
  lv_size = 4
  lv_size_unit = GB
  name = /dev/vg00/lvol1
  open_lv = 0
  read_ahead = 1024
  status = available
  write_access = read/write
  
  alloc_le = 1280
  allocation = next free
  cur_le = 1280
  device = 58:1
  lv_number = 2
  lv_size = 5
  lv_size_unit = GB
  name = /dev/vg00/lvol2
  open_lv = 0
  read_ahead = 1024
  status = available
  write_access = read/write
  
  alloc_le = 1536
  allocation = next free
  cur_le = 1536
  device = 58:2
  lv_number = 3
  lv_size = 6
  lv_size_unit = GB
  name = /dev/vg00/lvol3
  open_lv = 0
  read_ahead = 1024
  status = available
  write_access = read/write
   
   
  get_physical_volume_information($)	This routine will return all of the information
					information about the physical volumes assigned 
					to the specified volume group.
   
  %%pv = get_physical_volume_information("vg00");
  foreach $pvname (sort keys %%pv) {
      foreach(sort keys %%{$pv{$pvname}}) {
          print "$_ = $pv{$pvname}->{$_}\n";
      }
      print "\n";
  }
  Would yield the following results:
  device = /dev/hda3
  free_pe = 0
  pv_number = 1
  status = available / allocatable
  total_pe = 2160
  
  device = /dev/hda4
  free_pe = 864
  pv_number = 2
  status = available / allocatable
  total_pe = 2544
              
              
  get_lv_info($)	This routine will return all of the information about the
			specified logical volume.  The information will be returned
			in a hash.
              
  get_lv_info
  %%lv = get_lv_info("/dev/vg00/lvol1");
  foreach (sort keys %%lv) {
      print "$_ = $lv{$_} \n";
  }
  Would yield the following results:
  access = read/write 
  alloc_le = 1024 
  allocation = next free 
  block_device = 58:0 
  current_le = 1024 
  lv_name = /dev/vg00/lvol1 
  lv_number = 1 
  lv_open = 0 
  read_ahead = 1024 
  size = 4 
  size_unit = GB 
  status = available 
  vg_name = vg00 
              
              
              
  get_pv_info($)	This routine will return all of the information about the
			specified physical volume.  The information will be returned
			in a hash.
              
  %%pv = get_pv_info("/dev/hda3");
  foreach (sort keys %%pv) {
      print "$_ = $pv{$_} \n";
  }
  Would yield the following results:
  alloc_pe = 2160 
  allocatable = yes (but full) 
  free_pe = 0 
  num_lvols = 2 
  pe_size = 4096 
  pe_size_unit = KByte 
  pv_name = /dev/hda3 
  pv_number = 1 
  sectors = 17703630 
  size = 8.44 
  size_info = NOT usable 4.19 MB [LVM: 136 KB] 
  size_unit = GB 
  status = available 
  total_pe = 2160 
  uuid = 2c5ADu-oEdt-ovCe-rqp0-MWpF-I5u1-8XigH4 
  vg_name = vg00 
              
                   
     
  Command Output Used In The Above Examples: /sbin/vgdisplay -v
  --- Volume group ---
  VG Name               vg00
  VG Access             read/write
  VG Status             available/resizable
  VG #                  0
  MAX LV                256
  Cur LV                3
  Open LV               0
  MAX LV Size           255.99 GB
  Max PV                256
  Cur PV                2
  Act PV                2
  VG Size               18.38 GB
  PE Size               4 MB
  Total PE              4704
  Alloc PE / Size       3840 / 15 GB
  Free  PE / Size       864 / 3.38 GB
  VG UUID               BBq8si-NyRR-9ZNW-3J5e-DoRO-RBHK-ckrszi
  
  --- Logical volume ---
  LV Name                /dev/vg00/lvol1
  VG Name                vg00
  LV Write Access        read/write
  LV Status              available
  LV #                   1
  # open                 0
  LV Size                4 GB
  Current LE             1024
  Allocated LE           1024
  Allocation             next free
  Read ahead sectors     1024
  Block device           58:0
  
  --- Logical volume ---
  LV Name                /dev/vg00/lvol2
  VG Name                vg00
  LV Write Access        read/write
  LV Status              available
  LV #                   2
  # open                 0
  LV Size                5 GB
  Current LE             1280
  Allocated LE           1280
  Allocation             next free
  Read ahead sectors     1024
  Block device           58:1
  
  --- Logical volume ---
  LV Name                /dev/vg00/lvol3
  VG Name                vg00
  LV Write Access        read/write
  LV Status              available
  LV #                   3
  # open                 0
  LV Size                6 GB
  Current LE             1536
  Allocated LE           1536
  Allocation             next free
  Read ahead sectors     1024
  Block device           58:2
  
  --- Physical volumes ---
  PV Name (#)           /dev/hda3 (1)
  PV Status             available / allocatable
  Total PE / Free PE    2160 / 0
  
  PV Name (#)           /dev/hda4 (2)
  PV Status             available / allocatable
  Total PE / Free PE    2544 / 864



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*
%changelog
