# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(IO/Dir.pm) perl(IO/File.pm) perl(IO/Socket/INET.pm) perl(List/Util.pm) perl(Math/BigInt.pm) perl(POSIX.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(syscall.ph)
# END SourceDeps(oneline)
%define module_name Linux-Landlock
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9.2
Release: alt1
Summary: An interface to the Landlock sandboxing facility of Linux
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MB/MBALLARIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Landlock is a sandboxing feature specific to Linux that allows a process to
restrict its own access to the file system.
Once set, restrictions cannot be undone and they are inherited by all future
child processes.

Since the restrictions are set at runtime, from within the process itself,
you can take into account dynamic information from your configuration.

For example, a server that is supposed to serve files from a specific directory
can restrict itself to that directory and its subdirectories to mitigate any bugs
allowing directory traversal attacks. This is much less intrusive than chroot
and does not require root privileges.

This module provides an object-oriented interface to the Linux Landlock API.
It uses the lower-level interface provided by the Linux::Landlock::Direct manpage.

See https://docs.kernel.org/userspace-api/landlock.html for more information
about Landlock.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING README.md README LICENSE
%perl_vendor_privlib/L*

%changelog
