%define module_name List-AutoNumbered
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getargs/Mixed.pm) perl(Import/Into.pm) perl(Module/Metadata.pm) perl(Path/Class.pm) perl(Pod/Markdown.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(lib/relative.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000010
Release: alt1
Summary: Add line numbers to lists while creating them
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CX/CXW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module adds sequential numbers to lists of lists so you don't have to
type all the numbers.  Its original use case was for adding line numbers
to lists of testcases.  For example:

    use List::AutoNumbered;
    use Test::More tests => 1;

    my $list = List::AutoNumbered->new;     # First entry will be number 1
    $list->load('a')->      # Yes, trailing arrow
        ('b')               # Magic!  Don't need any more arrows!
        ('c')
        ('d');

    is_deeply($list->arr, [
        [1, 'a'], [2, 'b'], [3, 'c'], [4, 'd']
    ]);     # Yes, it is!

For automatic line numbering, just pass `__LINE__' to the constructor:

    use List::AutoNumbered;                             # line 1
    my $list = List::AutoNumbered->new(__LINE__);       # line 2
    $list->load('a')->                                  # line 3
        ('b')                                           # line 4
        ('c')                                           # line 5
        ('d');                                          # line 6

    # Now $list->arr is [ [3,'a'], [4,'b'], [5,'c'], [6,'d'] ]

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md README
%perl_vendor_privlib/L*

%changelog
