%define module_version 0.09
%define module_name List-BinarySearch-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt6
Summary: Binary Search a sorted array with XS routines.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDO/%{module_name}-%{module_version}.tar.gz

%description
A binary search searches *sorted* lists using a divide and conquer technique.
On each iteration the search domain is cut in half, until the result is found.
The computational complexity of a binary search is O(log n).

This module implements several Binary Search algorithms using XS code for
optimal performance.  You are free to use this module directly, or as a plugin
for the more general the List::BinarySearch manpage.

The binary search algorithm implemented in this module is known as a
*Deferred Detection* Binary Search.  Deferred Detection provides
stable searches.  Stable binary search algorithms have the following
characteristics, contrasted with their unstable binary search cousins:

=over 4

=item * In the case of non-unique keys, a stable binary search will always
return the lowest-indexed matching element.  An unstable binary search would
return the first one found, which may not be the chronological first.

=item * Best and worst case time complexity is always O(log n).  Unstable
searches may stop once the target is found, but in the worst case are still
O(log n).  In practical terms, this difference is usually not meaningful.

=item * Stable binary searches only require one relational comparison of a
given pair of data elements per iteration, where unstable binary searches
require two comparisons per iteration.

=item * The net result is that although an unstable binary search might have
better "best case" performance, the fact that a stable binary search gets away
with fewer comparisons per iteration gives it better performance in the worst
case, and approximately equal performance in the average case. By trading away
slightly better "best case" performance, the stable search gains the guarantee
that the element found will always be the lowest-indexed element in a range of
non-unique keys.

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/L*
%perl_vendor_autolib/*

%changelog
