%define module_name List-Insertion
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Combination.pm) perl(ExtUtils/MakeMaker.pm) perl(List/BinarySearch/PP.pm) perl(List/BinarySearch/XS.pm) perl(Template/Plex.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: Binary search a list for insertion point
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
the List::Insertion manpage implements binary search algorithms to locate the
insertion point of a sorted list for a given value. If the value were to be
inserted at that position, the list would remain sorted.

A distinction is made between inserting left or right of an exact match or
duplicated entry. This allows to insert data before contiguous equal items or
after.

Performance rather than flexibility is favoured in the implementation and
necessitates the following restrictions on the data stored in the array/list
and how it's compared:

=over 

=item Data must be sorted in asscending order only

This simplifies the combinations of subroutines exported

=item No code blocks can be specified

While code blocks are very flexible, 90%% of the functionality can be achieved
with 'accessor' snippets.

=item Element comparision is implicitly numerical or string

No object methods for comparison. Only basic `<=>', `>=', `le'
and `ge' operators are used for internally for string and numeric comparison.

=item List element must be homogeneous and defined 

All items in the list are expected to have the same data structure. The
structure  can be a simple scalar like a string or number, in which case no
'acceesor' snippet is used. 

On the other hand it could be complex, like an array of arrays or hashes of
objects to any level. The only restriction in this case is the 'accessor'
snippet is able to access the value for comparison via post dereferencing or
method calls

=back

Although intended for searching for a insertion point, this module can also be
used for general searching of elements. A simple check of equality between the
search key and  value at the found index will determine if the value was
actually found or not.

The returned index will never indicate 'not found' as there is always a insert
location in a list.

No symbols are exported by default. Specifications given at import time are
used to generate and export the search routine (s) needed. Anonymous search
subroutines can also be generated.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README README.md
%perl_vendor_privlib/L*

%changelog
