# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(IO/Zlib.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name List-Prefixed
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Prefixed String List
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOETHIN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The idea of a *Prefixed List* comes from regular expressions determining a finite
list of words, like this:

  /(?:Ba(?:r|z)?|F(?:o(?:o(?:d|t)?|r(?:m)?)|u))/
  
The expression above matches exactly these strings:

  "Ba", "Bar", "Baz", "Foo", "Food", "Foot", "For", "Form", "Fu".

Representing a string list that way can have some advantages in certain situations:

=over 4

=item *

The regular expression provides efficient test methods on arbitrary strings
(e.g. whether or not a string is contained in the list or starts or ends with an element
from the list).

=item *

The representaion is compressing, depending on how many shared prefixes appear in a list.

=item *

Conversely, a prefixed list can be efficiently set up from such a regular expression.
Thus, the prefixed list leads to a natural way of serialization and de-serialization.

=item *

Sub lists sharing a common prefix can be extracted efficently from a prefixed list. 
This leads to an efficient implementation of auto-completion.

=back

For example, from Perl package names
indexed on CPAN, one can get a list of about 82K module names that takes more than 2M data.
We can compress the list to a regular expression of about 900K that matches exactly all these names.

A *Prefixed List* is a tree consisting of node triples, formally defined as follows:

  node: ( prefix [node-list] opt )
    where:
      prefix: String
      node-list: List of node
      opt: Boolean

The list elements are the prefix strings, each of them appended to the prefix of the parent node. 
The `opt' flag is true if the list of sub nodes is optional, i.e., if the node prefix appended 
together with the parent prefixes is also contained in the list itself.
      
Any string list has a trivial representation that way, if one takes each string as the prefix
of a node with empty node-list and collects all these nodes into a parent node with empty prefix.

A prefixed tree is called *folded*, if it's in minimal form, i.e. if there are no two
child nodes in a parent node sharing a common left part in their prefixes. Obviously, for 
each string list, there exists a unique folded *Prefixed Tree* representation.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod README README.md
%perl_vendor_privlib/L*

%changelog
