%define module_name List-Rank
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Ranking of list elements
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/List-Rank

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Return the ranks of the elements if sorted numerically (note that equal values
will be given equal ranks):

 my @ranks = rank 10, 30, 20, 20; # => 1, 4, "2=", "2="

Return the ranks of the elements if sorted ascibetically:

 my @ranks = rankstr "apricot", "cucumber", "banana", "banana"; # => 1,4,"2=","2="

Return the ranks of the elements if sorted by a custom sorter:

 my @ranks = rankby {length($a) <=> length($b)}
     "apricot", "cucumber", "banana", "banana"; # => 3, 4, "1=", "1="

Sort the list numerically and return the elements as well as ranks in pairs:

 my @res = sortrank 10, 30, 20, 20; => 10,1, 20,"2=", 20,"2=", 30,4

Sort the list ascibetically and return the elements as well as ranks in pairs:

 my @res = sortrankstr "apricot", "cucumber", "banana", "banana";
     # => "apricot",1, "banana","2=", "banana","2=", "cucumber",4

Sort the list by a custom sorter and return the elements as well as ranks in
pairs:

 my @res = sortrankby "apple", "cucumber", "banana", "banana";
     # => "banana","1=", "banana","1=", "apricot",3, "cucumber",4

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/L*

%changelog
