# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/Installed.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Packlist.pm) perl(Memoize.pm) perl(Module/Signature.pm) perl(Socket.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.010
%define module_name List-Rotation
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.010
Release: alt1
Summary: Loop (Cycle, Alternate or Toggle) through a list of values via a singleton object implemented as cl...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PE/PELAGIC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Use `List::Rotation' to loop through a list of values.
Once you get to the end of the list, you go back to the beginning.
Alternatively you can walk backwards through your list of values.

`List::Rotation' is implemented as a Singleton Pattern. You always just
get 1 (the very same) Rotation object if you use the `new' method several times
with the exact same set of parameters.
This is done by using `Memoize' on the `new' method. It returns the same object
for every use of `new' that comes with the same list of parameters.

The class `List::Rotation' contains three subclasses:

=over 4

=item `List::Rotation::Cycle'

Loop through a list of arbitrary values. The list must not be empty.

=item `List::Rotation::Alternate'

Alternate two values.

=item `List::Rotation::Toggle'

Toggle between true and false.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/uninstall

%files
%doc README Changes examples
%perl_vendor_privlib/L*

%changelog
