Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Locale-SubCountry
Version:        2.07
Release:        alt1_12
Summary:        ISO 3166-2 two letter subcountry codes
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Locale-SubCountry
Source0:        https://cpan.metacpan.org/authors/id/K/KI/KIMRYAN/Locale-SubCountry-%{version}.tar.gz
# Normalize Changes encoding
Patch0:         Locale-SubCountry-2.04-Convert-to-UTF-8.patch
BuildArch:      noarch 
BuildRequires:  coreutils
BuildRequires:  perl(Config.pm)
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(JSON.pm)
BuildRequires:  perl(locale.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
Requires:       perl(JSON.pm) >= 1
Requires:       perl(locale.pm) >= 1

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(JSON\|locale\|Test.More\).pm)/d

%description
This module allows you to convert the full name for a countries administrative
region to the code commonly used for postal addressing. The reverse look-up
can also be done. Sub country codes are defined in "ISO 3166-2:2007, Codes for
the representation of names of countries and their subdivisions".

Sub countries are termed as states in the US and Australia, provinces in
Canada and counties in the UK and Ireland.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/More.pm) >= 0.940

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Locale-SubCountry-%{version}
%patch0  -p1
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENCE
%doc Changes README examples/
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
