# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Net/FTP.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.32
%define module_name LockFile-NetLock
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.32
Release: alt1
Summary: FTP based locking using the FTP mkdir command.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/RONALDWS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Provide locking/mutex mechanism under (at least) UNIX and
Win32 that will function correctly even in networked/NFS
environments.  It is based on the concept that if two 
processes each connect to the same host via ftp and try
to create the same directory that does not yet exist then
one will create the directory and the other will be notified
that it cannot create the directory because it already exists.
The basic ideas are explained in more detail in an article
in the summer 2002 Perl journal by Sean M. Burke.

As demonstrated in the SYNOPSIS the module has two interfaces:
an object oriented interface and a more traditional subroutine
interface.  The four most critical parameters, the host name,
directory, ftp user and password may be passed unnamed as a list
or named with the respective labels -host, -dir, -user, 
-password.  There are also several optional parameters that
control the timing of lock events including a total timeout
parameter, a sleep time between attempts to create the
directory, and a heartbeat option controlling the frequency
of verifying the running or dead status of the process that
requested the lock.  The options and parameters are
discussed in an itemized format in the parameters 
sections below.

It is strongly recommended that users of this module upgrade their Net::FTP
module to at least version 2.64.  Earlier versions may make errors in
removing a lock undetectable.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/L*

%files scripts
%_bindir/*

%changelog
